/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.dpi;

import com.ibm.hwmca.api.SNMPEndOfMibViewException;
import com.ibm.hwmca.api.SNMPNoSuchObjectException;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.dpi.DpiConstants;
import com.ibm.hwmca.fw.dpi.DpiErrorIds;
import com.ibm.hwmca.fw.dpi.DpiException;
import com.ibm.hwmca.fw.dpi.DpiHandler;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.net.LocalSocket;
import com.ibm.hwmca.fw.snmp.SnmpConstants;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.HashMap;

public class DpiConnection
implements DpiConstants,
SnmpConstants,
DpiErrorIds {
    private static final int TIMEOUT = 5;
    private static final int MAX_VAR_BINDS = 0;
    private static final byte CHARSET = 0;
    private static final int PRIORITY = 5;
    private static final String SUB_AGENT_ID = "1.3.6.1.4.1.2.2.1";
    private static final String SUB_AGENT_DESC = "HMC DPI Sub-Agent";
    private static final String PASSWORD = "";
    private DpiHandler handler;
    private LocalSocket socket;
    private BufferedOutputStream out;
    private BufferedInputStream in;
    private HashMap requests = new HashMap();
    private String socketName;
    private short packet_id = 0;
    private static final String TRACE_MASKT = "XDPIC  T";
    private static final String TRACE_MASKD = "XDPIC  D";
    private static final String TRACE_MASKF = "XDPIC  F";

    public DpiConnection(DpiHandler handler) throws DpiException {
        this.handler = handler;
        try {
            this.socketName = BaseFileControl.getFilePath("domainsocket") + "dpi.socket";
            this.socket = new LocalSocket(this.socketName);
            this.out = new BufferedOutputStream(this.socket.getOutputStream());
            this.in = new BufferedInputStream(this.socket.getInputStream());
        }
        catch (IOException ioe) {
            Trace.trace(TRACE_MASKF, "IOException in DpiConnection constructor");
            Trace.trace(TRACE_MASKF, ioe);
            throw new DpiException("IOException: " + ioe.getMessage());
        }
        catch (HException hexc) {
            Trace.trace(TRACE_MASKF, "Failed call to BaseFileControl.getFilePath in DpiConnection constructor");
            Trace.trace(TRACE_MASKF, hexc);
            throw new DpiException("HException: " + hexc.getMessage());
        }
    }

    public void openConnection() throws DpiException, IOException {
        int length = 17 + SUB_AGENT_ID.length() + SUB_AGENT_DESC.length() + PASSWORD.length();
        Trace.trace(TRACE_MASKD, "packet length=" + length);
        byte[] packet = this.createPacket(length, (byte)8, this.packet_id);
        packet[8] = 0;
        packet[9] = 5;
        packet[10] = 0;
        packet[11] = 0;
        packet[12] = 0;
        byte[] subAgentIdBytes = SUB_AGENT_ID.getBytes();
        System.arraycopy(subAgentIdBytes, 0, packet, 13, subAgentIdBytes.length);
        packet[13 + subAgentIdBytes.length] = 0;
        int offset = subAgentIdBytes.length + 14;
        byte[] subAgentDescBytes = SUB_AGENT_DESC.getBytes();
        System.arraycopy(subAgentDescBytes, 0, packet, offset, subAgentDescBytes.length);
        packet[offset + subAgentDescBytes.length] = 0;
        offset += subAgentDescBytes.length + 1;
        if (PASSWORD.equals(PASSWORD)) {
            packet[offset++] = 0;
            packet[offset] = 0;
        } else {
            packet[offset++] = (byte)(PASSWORD.length() >> 8);
            packet[offset++] = (byte)PASSWORD.length();
            byte[] passwordBytes = PASSWORD.getBytes();
            System.arraycopy(passwordBytes, 0, packet, offset, passwordBytes.length);
        }
        this.out.write(packet);
        this.out.flush();
        Trace.trace(TRACE_MASKD, "sent packet");
        byte[] lengthBuf = new byte[2];
        this.in.read(lengthBuf, 0, 2);
        length = (short)((lengthBuf[0] & 0xFF) << 8 | lengthBuf[1] & 0xFF);
        Trace.trace(TRACE_MASKD, "response packet length=" + length);
        byte[] response = new byte[length];
        int rc = 0;
        for (int bytesRead = 0; bytesRead < length; bytesRead += rc) {
            rc = this.in.read(response, bytesRead, length - bytesRead);
            if (rc != -1) continue;
            Trace.trace(TRACE_MASKF, "Reached end of stream before reading all expected bytes");
            throw new DpiException("Error reading packet: reached end of stream before expected bytes read");
        }
        short in_packet_id = (short)((response[3] & 0xFF) << 8 | response[4] & 0xFF);
        if (in_packet_id != this.packet_id) {
            throw new DpiException("Response packet id mismatch");
        }
        if (response[5] != 5) {
            throw new DpiException("Invalid packet type in response");
        }
        if (response[6] != 0) {
            System.out.println("Agent responded with an error: " + response[6]);
            throw new DpiException("DPI Error: " + response[6]);
        }
        this.packet_id = (short)(this.packet_id + 1);
        new PacketHandler().start();
    }

    public void registerSubTree(String groupId) throws DpiException, IOException {
        this.requests.put(new Integer(this.packet_id), new RequestMapEntry(groupId, 6));
        int length = 17 + groupId.length();
        Trace.trace(TRACE_MASKD, "packet length: " + length);
        short s = this.packet_id;
        this.packet_id = (short)(s + 1);
        byte[] packet = this.createPacket(length, (byte)6, s);
        packet[8] = 0;
        packet[9] = 0;
        packet[10] = 0;
        packet[11] = 5;
        packet[12] = 0;
        packet[13] = 5;
        packet[14] = 0;
        packet[15] = 1;
        byte[] groupIdBytes = groupId.getBytes();
        System.arraycopy(groupIdBytes, 0, packet, 16, groupIdBytes.length);
        packet[16 + groupIdBytes.length] = 0;
        this.out.write(packet);
        this.out.flush();
        Trace.trace(TRACE_MASKD, "sent packet");
    }

    public void unregisterSubTree(String groupId) throws DpiException, IOException {
        this.requests.put(new Integer(this.packet_id), new RequestMapEntry(groupId, 7));
        int len = 10 + groupId.length();
        short s = this.packet_id;
        this.packet_id = (short)(s + 1);
        byte[] packet = this.createPacket(len, (byte)7, s);
        byte[] groupIdBytes = groupId.getBytes();
        System.arraycopy(groupIdBytes, 0, packet, 9, groupIdBytes.length);
        packet[9 + groupIdBytes.length] = 0;
        this.out.write(packet);
        this.out.flush();
        Trace.trace(TRACE_MASKD, "sent packet");
    }

    private byte[] createPacket(int length, byte type, short id) {
        if (length < 8) {
            throw new IllegalArgumentException("size of packet was less than 8");
        }
        byte[] packet = new byte[length];
        packet[0] = (byte)((length -= 2) >> 8);
        packet[1] = (byte)length;
        packet[2] = 2;
        packet[3] = 2;
        packet[4] = 0;
        packet[5] = (byte)(id >> 8);
        packet[6] = (byte)id;
        packet[7] = type;
        return packet;
    }

    static /* synthetic */ BufferedInputStream access$000(DpiConnection x0) {
        return x0.in;
    }

    static /* synthetic */ short access$102(DpiConnection x0, short x1) {
        x0.packet_id = x1;
        return x0.packet_id;
    }

    static /* synthetic */ HashMap access$300(DpiConnection x0) {
        return x0.requests;
    }

    private class PacketHandler
    extends Thread {
        private boolean running = true;

        PacketHandler() {
            super("DpiConnection.PacketHandler thread");
        }

        /*
         * Exception decompiling
         */
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [13[DOLOOP]], but top level block is 14[WHILELOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void processGetRequest(String oid, String community, short packet_id) {
            byte[] response = null;
            try {
                Object val = DpiConnection.this.handler.get(oid);
                if (oid.charAt(0) != '.') {
                    oid = "." + oid;
                }
                response = this.createResponse(oid, val);
            }
            catch (SNMPNoSuchObjectException nsoe) {
                Trace.trace(DpiConnection.TRACE_MASKD, "GET: Object Not Found");
                int len = 17 + oid.length();
                response = DpiConnection.this.createPacket(len, (byte)5, packet_id);
                response[8] = 0;
                byte[] byteBuf = oid.getBytes();
                System.arraycopy(byteBuf, 0, response, 13, byteBuf.length);
                int offset = 13 + byteBuf.length;
                response[offset++] = 0;
                response[offset++] = 15;
                response[offset++] = 0;
                response[offset] = 0;
            }
            catch (Exception e) {
                Trace.trace(DpiConnection.TRACE_MASKF, "Error in processGetRequest");
                Trace.trace(DpiConnection.TRACE_MASKF, e);
                new FrameworkLog(DpiErrorIds.logInfo, 4101, e).log();
                response = DpiConnection.this.createPacket(13, (byte)5, packet_id);
                response[8] = 5;
            }
            this.sendPacket(response);
        }

        private void processGetNextRequest(String oid, String community, short packet_id) {
            byte[] response = null;
            try {
                Object[] val = DpiConnection.this.handler.getNext(oid);
                String new_oid = (String)val[0];
                if (new_oid.charAt(0) != '.') {
                    new_oid = "." + new_oid;
                }
                response = this.createResponse(new_oid, val[1]);
            }
            catch (SNMPEndOfMibViewException mve) {
                Trace.trace(DpiConnection.TRACE_MASKD, "caught end of mib view exception");
                Trace.trace(DpiConnection.TRACE_MASKD, mve);
                int len = 17 + oid.length();
                response = DpiConnection.this.createPacket(len, (byte)5, packet_id);
                response[8] = 0;
                byte[] byteBuf = oid.getBytes();
                System.arraycopy(byteBuf, 0, response, 13, byteBuf.length);
                int offset = 13 + byteBuf.length;
                response[offset++] = 0;
                response[offset++] = 17;
                response[offset++] = 0;
                response[offset] = 0;
            }
            catch (Exception e) {
                Trace.trace(DpiConnection.TRACE_MASKF, "Error in processGetNextRequest");
                Trace.trace(DpiConnection.TRACE_MASKF, e);
                new FrameworkLog(DpiErrorIds.logInfo, 4101, e).log();
                response = DpiConnection.this.createPacket(13, (byte)5, packet_id);
                response[8] = 5;
            }
            this.sendPacket(response);
        }

        private void processSetRequest(String oid, Object value, String community, short packet_id) {
            Trace.trace(DpiConnection.TRACE_MASKT, "-> processSetRequest(" + oid + "," + value + "," + community + "," + packet_id + ")");
            byte[] response = DpiConnection.this.createPacket(13, (byte)5, packet_id);
            try {
                DpiConnection.this.handler.set(oid, value);
                Trace.trace(DpiConnection.TRACE_MASKD, "called handler.set()");
                response[8] = 0;
            }
            catch (Exception e) {
                Trace.trace(DpiConnection.TRACE_MASKD, "exception in handler.set()");
                Trace.trace(DpiConnection.TRACE_MASKD, e);
                response[8] = 5;
            }
            this.sendPacket(response);
            Trace.trace(DpiConnection.TRACE_MASKT, "<- processSetRequest(" + oid + "," + value + "," + community + "," + packet_id + ")");
        }

        private void sendPacket(byte[] packet) {
            try {
                DpiConnection.this.out.write(packet);
                DpiConnection.this.out.flush();
                Trace.trace(DpiConnection.TRACE_MASKF, "sent packet");
            }
            catch (IOException ioe) {
                Trace.trace(DpiConnection.TRACE_MASKF, "Error sending packet");
                Trace.trace(DpiConnection.TRACE_MASKF, ioe);
                new FrameworkLog(DpiErrorIds.logInfo, 4097, ioe).log();
            }
        }

        private byte[] createResponse(String oid, Object val) {
            byte[] response = val == null ? this.createNullResponse(oid) : (val instanceof String ? this.createStringResponse(oid, (String)val) : (val instanceof Integer ? this.createIntegerResponse(oid, (Integer)val) : (val instanceof Boolean ? this.createIntegerResponse(oid, (Boolean)val != false ? 1 : 0) : (val instanceof InetAddress ? this.createIpAddrResponse(oid, (InetAddress)val) : this.createStringResponse(oid, val.toString())))));
            return response;
        }

        private byte[] createStringResponse(String oid, String val) {
            int len = 17 + oid.length() + val.length();
            byte[] response = DpiConnection.this.createPacket(len, (byte)5, DpiConnection.this.packet_id);
            response[8] = 0;
            byte[] byteBuf = oid.getBytes();
            System.arraycopy(byteBuf, 0, response, 13, byteBuf.length);
            int offset = 13 + byteBuf.length;
            response[offset++] = 0;
            response[offset++] = 2;
            len = val.length();
            response[offset++] = (byte)(len >> 8);
            response[offset++] = (byte)len;
            byteBuf = val.getBytes();
            System.arraycopy(byteBuf, 0, response, offset, byteBuf.length);
            return response;
        }

        private byte[] createIntegerResponse(String oid, int val) {
            int len = 21 + oid.length();
            byte[] response = DpiConnection.this.createPacket(len, (byte)5, DpiConnection.this.packet_id);
            response[8] = 0;
            byte[] byteBuf = oid.getBytes();
            System.arraycopy(byteBuf, 0, response, 13, byteBuf.length);
            int offset = 13 + byteBuf.length;
            response[offset++] = 0;
            response[offset++] = -127;
            response[offset++] = 0;
            response[offset++] = 4;
            response[offset++] = (byte)(val >> 24);
            response[offset++] = (byte)(val >> 16);
            response[offset++] = (byte)(val >> 8);
            response[offset++] = (byte)val;
            return response;
        }

        private byte[] createIpAddrResponse(String oid, InetAddress addr) {
            int len = 21 + oid.length();
            byte[] response = DpiConnection.this.createPacket(len, (byte)5, DpiConnection.this.packet_id);
            response[8] = 0;
            byte[] byteBuf = oid.getBytes();
            System.arraycopy(byteBuf, 0, response, 13, byteBuf.length);
            int offset = 13 + byteBuf.length;
            response[offset++] = 0;
            response[offset++] = 5;
            response[offset++] = 0;
            response[offset++] = 4;
            byteBuf = addr.getAddress();
            System.arraycopy(byteBuf, 0, response, offset, 4);
            return response;
        }

        private byte[] createNullResponse(String oid) {
            int len = 17 + oid.length();
            byte[] response = DpiConnection.this.createPacket(len, (byte)5, DpiConnection.this.packet_id);
            response[8] = 0;
            byte[] byteBuf = oid.getBytes();
            System.arraycopy(byteBuf, 0, response, 13, byteBuf.length);
            int offset = 13 + byteBuf.length;
            response[offset++] = 0;
            response[offset++] = 4;
            response[offset++] = 0;
            response[offset++] = 0;
            return response;
        }
    }

    private static class RequestMapEntry {
        String oid;
        byte type;

        RequestMapEntry(String oid, byte type) {
            this.oid = oid;
            this.type = type;
        }
    }
}

